clear
set more off

********************************************************************************
********************************************************************************
***** Proportional rate of progress comparison
**Synthesis graphs - figures 5.1-5.4

** John W. McArthur & Krista Rasmussen
** January 2017
********************************************************************************
********************************************************************************

****************************************************************
**MMR and U5MR - birth-weighted average for 1990, 2000, and 2015; RP 90-00 RP 00-15
*1. LIC ex India
*2. MIC ex China
*3. SSA
*4. China and India
*5. RoW (ex. China, India, SSA)
****************************************************************
local lista "maternal_mort_modeled_analysis u5mr_analysis" 
foreach p of local lista{
clear

clear
use "`p'"
drop if IncomeGroup=="H"

keep CountryName CountryCode IncomeGroup Region n1990 n2000 n2015 birth1990 birth2015 birth2000
 * Reshape long to enable collapse
reshape long n birth, i(CountryName CountryCode) j(year)
save "`p'_syn_LONG", replace

****************
*1. LIC ex India
****************
keep if IncomeGroup=="L"
drop if CountryCode=="IND"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "LIC ex India"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchng_LICexIND", replace

****************
*2. MIC ex China
****************
use "`p'_syn_LONG", clear
keep if IncomeGroup!="L"
drop if CountryCode=="CHN"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "MIC ex China"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchng_MICexCHN", replace

****************
*3. By Region
****************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of loca listreg{
use "`p'_syn_LONG", clear
keep if Region=="`reg'"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "`reg'"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchng`reg'", replace
}
****************
*4. India & China
****************
use "`p'", clear
keep if CountryCode=="CHN" | CountryCode=="IND"

keep CountryName n1990 n2000 n2015 birth1990 birth2015 birth2000
gen group = CountryName
drop CountryName 
 * RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchngINDCHN", replace

****************
*5. RoW (ex. China, India, SSA)
****************
use "`p'_syn_LONG", clear
drop if IncomeGroup=="H"
drop if Region=="SSA"
drop if CountryCode=="CHN" | CountryCode=="IND"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "RoW"
reshape wide n, i(group) j(year)
 *  RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchngRoW", replace

append using "`p'_pctchngSSA"
append using "`p'_pctchngEAP"
append using "`p'_pctchngLAC"
append using "`p'_pctchngMENA"
append using "`p'_pctchngSA"
append using "`p'_pctchngECA"
append using "`p'_pctchngINDCHN"
append using "`p'_pctchng_LICexIND"
append using "`p'_pctchng_MICexCHN"
gen indicator ="`p'"
save "`p'_pctchngMICLICSSA", replace
}

********************************************************************************
**Water and Sanitation
*1. LIC ex India
*2. MIC ex China
*3. SSA
*4. China and India
*5. RoW (ex. China, India, SSA)
********************************************************************************
local listd "improvedwater_pct__analysis improvedsanitation_pct__analysis"
foreach d of local listd{

clear
use "`d'"
drop if IncomeGroup=="H"

 *Missing data means variations in initial/final year across countries, use country-level rate of progress calculation to extrapolate 1990 value, 2015, and 2000
gen created1990 = n1990
 replace created1990 = rppre*(-1)+n1991 if created1990==.
 replace created1990 = rppre*(-2)+n1992 if created1990==.
 replace created1990 = rppre*(-3)+n1993 if created1990==.
 replace created1990 = rppre*(-4)+n1994 if created1990==.
 replace created1990 = rppre*(-5)+n1995 if created1990==.

gen created2015 = n2015
 replace created2015 = rppost*(1)+n2014 if created2015==.
 replace created2015 = rppost*(2)+n2013 if created2015==.
 replace created2015 = rppost*(3)+n2012 if created2015==.
 replace created2015 = rppost*(4)+n2011 if created2015==.
 replace created2015 = rppost*(5)+n2010 if created2015==. 
 
gen created2000 = n2000
 replace created2000 = rppre*(-1)+n2001 if created2000==.
 replace created2000 = rppre*(1)+n1999 if created2000==.

keep CountryName CountryCode IncomeGroup Region created1990 created2015 created2000 fulln2015 pop1990 pop2000 pop2015
reshape long fulln pop created, i(CountryName CountryCode) j(year)
save "`d'_LONG_all.dta", replace
keep if IncomeGroup=="L"
save "`d'_LONG_LIC.dta", replace

****************
*1. LIC ex India
****************
use "`d'_LONG_all.dta", replace
keep if IncomeGroup=="L"
drop if CountryCode=="IND"
save "`d'_LONG_LICexIND.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "LIC ex IND"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress; this is using the extrapolated value for 1990, 2000 and 2015
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchngLICexIND", replace

****************
*2. MIC ex China
****************
use "`d'_LONG_all.dta", replace
keep if IncomeGroup!="L"
drop if CountryCode=="CHN"
save "`d'_LONG_MICexCHN.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "MIC ex CHN"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress; this is using the extrapolated value for 1990, 2000 and 2015
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchngMICexCHN", replace

****************
*3. By Region
****************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "`d'_LONG_all.dta", replace
keep if Region=="`reg'"
save "`d'_LONG_`reg'.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "`reg'"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress; this is using the extrapolated value for 1990, 2000 and 2015
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchng`reg'", replace
}
****************
*4. India & China
****************
use "`d'_LONG_all.dta", replace
keep if CountryCode=="CHN" | CountryCode=="IND"
save "`d'_LONG_INDCHN.dta", replace

gen group = CountryName

 *RP calculations use % without to standardize
drop pop Region IncomeGroup fulln
 reshape wide created, i(group) j(year)
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress; this is using the extrapolated value for 1990, 2000 and 2015
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchngINDCHN", replace

****************
*5. RoW (ex. China, India, SSA)
****************
use "`d'_LONG_all.dta", replace
drop if Region=="SSA"
drop if CountryCode=="CHN" | CountryCode=="IND"
save "`d'_LONG_RoW.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "RoW"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress; this is using the extrapolated value for 1990, 2000 and 2015
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchngRoW", replace

append using "`d'_pctchngSSA"
append using "`d'_pctchngEAP"
append using "`d'_pctchngLAC"
append using "`d'_pctchngMENA"
append using "`d'_pctchngSA"
append using "`d'_pctchngECA"
append using "`d'_pctchngINDCHN"
append using "`d'_pctchngLICexIND"
append using "`d'_pctchngMICexCHN"
gen indicator ="`d'"
save "`d'_pctchngMICLICSSA", replace
}

*****************************************************
**Undernourishment
*use WB aggregate for SSA
*use country-level for China and India 
*use created "rest of world" (dev. ex China, India, SSA)
*****************************************************

****************
*1. WB Aggregate for regions
****************

*rename to ease merging
clear
use "undernourishment_ag_analysis.dta"
replace CountryCode="MENA" if CountryCode=="MNA"
replace CountryCode="SA" if CountryCode=="SAS"
save "undernourishment_ag_analysis_reg.dta", replace

local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "undernourishment_ag_analysis_reg.dta", clear
keep if CountryCode=="`reg'"

keep CountryName n1991 n2000 n2015 regpop1991 regpop2000 regpop2015
rename regpop1991 pop1991
rename regpop2000 pop2000
rename regpop2015 pop2015

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
 * rate of progress 1991-2000 and 2000-2015
gen rp9100 = 1-((n2000/n1991)^(1/9))
gen rp0015 = 1-((n2015/n2000)^(1/15))
gen group ="`reg'"
gen indicator = "undernourishment"
save "undernourishment_`reg'", replace
}
****************
*2. China and India
****************
use "undernourishment__analysis.dta", clear
keep if CountryName =="China" | CountryName=="India"
keep CountryName n1991 n2000 n2015 pop1991 pop2000 pop2015

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
 * rate of progress 1991-2000 and 2000-2015
gen rp9100 = 1-((n2000/n1991)^(1/9))
gen rp0015 = 1-((n2015/n2000)^(1/15))
rename CountryName group
gen indicator = "undernourishment"
save "undernourishment_ChiInd.dta", replace

****************
*3. Rest of World
****************
clear
use "undernourishment_ag_analysis.dta"
keep if CountryCode=="ROW"

keep CountryName n1991 n2000 n2015 

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
 * rate of progress 1991-2000 and 2000-2015
gen rp9100 = 1-((n2000/n1991)^(1/9)) 
gen rp0015 = 1-((n2015/n2000)^(1/15))
gen indicator = "undernourishment"
gen group="ROW"
save "undernourishment_ROW.dta", replace


*****************************************************
**Primary Completion Rate
*uses WB aggregate because available country-level data is low
*****************************************************
clear
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "primary_completion_ag_clean_analysis.dta"
keep if CountryCode=="`reg'"

keep CountryName n1990 n2000 n2013 n2012 n2011 n2010
 *RP calculations use % without to standardize
 *Cannot use proportional rate of change calculations when a value = 0, replace with .01%
foreach var of varlist n1990 n2000 n2013 n2012 n2011 n2010{
replace `var' = 1-`var'
replace `var' = .0001 if `var'<=0
}
 * rate of progress 1990-2000 and 2000-2013
gen rp9000 = 1-((n2000/n1990)^(1/10))
gen rp0013 = 1-((n2013/n2000)^(1/13))
 replace rp0013 = 1-((n2012/n2000)^(1/12)) if n2013==.
 replace rp0013 = 1-((n2011/n2000)^(1/11)) if n2013==. & n2012==.
 replace rp0013 = 1-((n2010/n2000)^(1/10)) if n2013==. & n2012==. & n2011==.

gen fulln2015 = n2013
 replace fulln2015 = n2012 if n2013==.
 replace fulln2015 = n2011 if n2013==. & n2012==.
 replace fulln2015 = n2010 if n2013==. & n2012==. & n2011==.
drop n2013 n2012 n2011 n2010
gen group ="`reg'"
gen indicator = "Primary Completion Rate"

foreach var of varlist n1990 n2000 fulln2015{
replace `var' = 0 if `var'<=.0001
}
save "PCR_`reg'", replace
}

*****************************************************
**Gender parity in primary
*uses WB aggregate because country level cannot be aggregated
*****************************************************
clear
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "genderratio_primary_aggregate_clean.dta", clear
for num 1990/2015: replace nX = 1 if nX>1 & nX!=.
keep if CountryCode=="`reg'"

keep CountryName n1990 n2000 n2013
 *RP calculations use % without to standardize
 *Cannot use proportional rate of change calculations when a value = 0, replace with .0001
foreach var of varlist n1990 n2000 n2013{
replace `var' = 1-`var'
replace `var' = .0001 if `var'<=0
}
gen rp9000 = 1-((n2000/n1990)^(1/10))
gen rp0013 = 1-((n2013/n2000)^(1/13))
 
gen fulln2015 = n2013
gen group ="`reg'"
gen indicator = "Gender Parity in Primary Education"

foreach var of varlist n1990 n2000 fulln2015{
replace `var' = 0 if `var'<= .0001
}

save "GPI_`reg'", replace
}
****************
**Gender Parity in China and India
****************
use "genderratio_primary_85_analysis.dta", clear
keep if CountryCode=="CHN" | CountryCode=="IND"

keep CountryName n1990 n2000 n2001 n2013 n2014 n2015
 *RP calculations use % without to standardize
 *Cannot use proportional rate of change calculations when a value = 0, replace with .01%
foreach var of varlist n1990 n2000 n2013{
replace `var' = 1-`var'
replace `var' = .0001 if `var'<=0
}
 * rate of progress 1990-2000 and 2000-2013
gen rp9000 = 1-((n2000/n1990)^(1/10))
 replace rp9000 = 1-((n2001/n1990)^(1/11)) if n2000==. //China
gen rp0013 = 1-((n2013/n2000)^(1/13))
 replace rp0013 = 1-((n2013/n2001)^(1/12)) if n2000==. //China
 
gen fulln2015 = n2013
gen group = CountryName
gen indicator = "Gender Parity in Primary Education"

foreach var of varlist n1990 n2000 fulln2015{
replace `var' = 0 if `var'<= .0001
}
save "GPI_ChiInd.dta", replace

********************************************************************************
********************************************************************************
***APPEND ALL FOR EXPORT and standardize names
********************************************************************************
********************************************************************************
local lista "maternal_mort_modeled_analysis improvedwater_pct__analysis improvedsanitation_pct__analysis"
use "u5mr_analysis_pctchngMICLICSSA.dta", clear

foreach p of local lista{
append using "`p'_pctchngMICLICSSA"
}

local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
append using "undernourishment_`reg'"
append using "PCR_`reg'"
append using "GPI_`reg'"
}
append using "GPI_ChiInd.dta"
append using "undernourishment_ChiInd.dta"
append using "undernourishment_ROW.dta"

replace n1990 = created1990 if created1990!=.
replace n2015 = created2015 if created2015!=.
replace n2000 = created2000 if created2000!=.

replace n1990 = n1991 if n1991!=.
replace n2015 = fulln2015 if fulln2015!=.

replace rp9000 = rppre if rppre!=.
replace rp0015 = rppost if rppost!=.

replace rp9000 = rp9100 if rp9100!=.
replace rp0015 = rp0013 if rp0013!=.

replace rp9000 = rppre_EX if rppre_EX!=.
replace rp0015 = rppost_EX if rppost_EX!=.

keep group n1990 n2000 n2015 rp9000 rp0015 indicator

order indicator group n1990 n2000 n2015 rp9000 rp0015
sort group indicator

****************
**Calculate the value of the problem in percent
****************
gen prob_pct1990 = n1990
replace prob_pct1990 = n1990/100000 if indicator=="maternal_mort_modeled_analysis"
replace prob_pct1990 = n1990/1000 if indicator=="u5mr_analysis"

gen prob_pct2015 = n2015
replace prob_pct2015 = n2015/100000 if indicator=="maternal_mort_modeled_analysis"
replace prob_pct2015 = n2015/1000 if indicator=="u5mr_analysis"

****************
**Calculate the share of the problem eliminated from 1990 to 2015
****************
gen share_elim = 1-(prob_pct2015/prob_pct1990)

****************
**Calculate the ratio of rate of progress pre and post
****************
gen rp_ratio = rp0015/rp9000
replace rp_ratio = . if rp_ratio<0 //calculation cannot be performed when rates of progress flip from negative to positive 

save "synthesis_scatter_proportional.dta", replace



